/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.util;

import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public final class NbtHelper {
    public static <T> ListTag write(NonNullList<T> list, BiFunction<T, CompoundTag, CompoundTag> serializer) {
        return NbtHelper.write(list, (T e) -> (CompoundTag)serializer.apply(e, new CompoundTag()));
    }

    public static <T, N extends Tag> ListTag write(NonNullList<T> list, Function<T, N> serializer) {
        ListTag tag = new ListTag();
        for (Object element : list) {
            tag.m_7614_(tag.size(), (Tag)serializer.apply(element));
        }
        return tag;
    }

    public static <T, N extends Tag> NonNullList<T> read(ListTag tag, Function<N, T> deserializer) {
        NonNullList list = NonNullList.m_182647_((int)tag.size());
        for (Tag element : tag) {
            list.add(deserializer.apply(element));
        }
        return list;
    }

    public static <T> Optional<T> maybe(CompoundTag tag, BiFunction<CompoundTag, String, T> function, String arg) {
        return Optional.ofNullable(tag.m_128441_(arg) ? (Object)function.apply(tag, arg) : null);
    }
}

